/**
* \file: e_sdc_ecm_dbus.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: sdc-ecm-engine
*
* \author: Kirill Marinushkin (kmarinushkin@de.adit-jv.com)
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
***********************************************************************/

#ifndef SDC_ECM_ENGINE_SRC_E_SDC_ECM_DBUS_H_
#define SDC_ECM_ENGINE_SRC_E_SDC_ECM_DBUS_H_

#include <pthread.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <time.h>
#include <openssl/ossl_typ.h>
#include <systemd/sd-bus.h>

#define DBUS_MESSAGE_TIMEOUT_USEC   (2 * 1000 * 1000)

#ifdef NO_SDC_PREHASHED_SIGN
#define HASH_TIMEOUT                300

struct sdc_ecm_hash_ctx {
    uint8_t ready;
    uint8_t *data;
    size_t len;
    EVP_MD_CTX *md_ctx;
    uint8_t hash[EVP_MAX_MD_SIZE];
    size_t hash_len;
    time_t timestamp;
    struct sdc_ecm_hash_ctx *next;
};
#endif /* NO_SDC_PREHASHED_SIGN */

struct sdc_ecm_dbus_ctx {
    sd_bus *bus;
    char *bus_type_str;
    bool is_bus_type_user;
    char *ecm_bus_name;
    char *ecm_obj_path;
    char *ecm_iface_name;
    struct sdc_ecm_hash_ctx *tohash_head;
    bool is_server_cert_checked;
    bool is_server_cert_check_skippable;
    pthread_mutex_t mut_dbus;
    pthread_mutex_t mut_hash;
};

struct sdc_ecm_key_ctx {
    uint8_t ready;
    X509 *cert;
    EVP_PKEY *pkey;
};

int sdc_ecm_dbus_set_bus_type(struct sdc_ecm_dbus_ctx *ctx, const char *p);
int sdc_ecm_dbus_set_bus_name(struct sdc_ecm_dbus_ctx *ctx, const char *p);
int sdc_ecm_dbus_set_iface_name(struct sdc_ecm_dbus_ctx *ctx, const char *p);

int sdc_ecm_dbus_init(struct sdc_ecm_dbus_ctx *ctx,
        struct sdc_ecm_key_ctx *key_ctx);
void sdc_ecm_dbus_finish(struct sdc_ecm_dbus_ctx *ctx,
        struct sdc_ecm_key_ctx *key_ctx);

int sdc_ecm_dbus_hash_init(EVP_MD_CTX *md_ctx, struct sdc_ecm_dbus_ctx *ctx,
        size_t digest_len);
int sdc_ecm_dbus_hash_update(EVP_MD_CTX *md_ctx, struct sdc_ecm_dbus_ctx *ctx,
        const void *data, size_t count);
int sdc_ecm_dbus_hash_final(EVP_MD_CTX *md_ctx, struct sdc_ecm_dbus_ctx *ctx,
        uint8_t *md);
int sdc_ecm_dbus_hash_copy(EVP_MD_CTX *to, EVP_MD_CTX *from,
        struct sdc_ecm_dbus_ctx *ctx);

int sdc_ecm_dbus_check_server_cert(struct sdc_ecm_dbus_ctx *ctx, X509 *cert);
int sdc_ecm_dbus_sign(struct sdc_ecm_dbus_ctx *ctx, int md_type,
        const uint8_t *in_data, size_t in_len,
        uint8_t *out_data, size_t *out_len);
int sdc_ecm_dbus_load_key_pair(ENGINE *e, struct sdc_ecm_dbus_ctx *ctx,
        struct sdc_ecm_key_ctx *key_ctx);
void sdc_ecm_dbus_cleanup_key_pair(struct sdc_ecm_key_ctx *key_ctx);

#endif /* SDC_ECM_ENGINE_SRC_E_SDC_ECM_DBUS_H_ */
